/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.validation;

import com.google.common.base.Strings;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.TTCN3ScopeHelper;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.tTCN3.AllOrSignatureList;
import de.ugoe.cs.swe.tTCN3.AllOrTypeList;
import de.ugoe.cs.swe.tTCN3.ComponentDef;
import de.ugoe.cs.swe.tTCN3.EnumDef;
import de.ugoe.cs.swe.tTCN3.EnumDefNamed;
import de.ugoe.cs.swe.tTCN3.GroupDef;
import de.ugoe.cs.swe.tTCN3.ModuleDefinition;
import de.ugoe.cs.swe.tTCN3.PortDef;
import de.ugoe.cs.swe.tTCN3.ProcOrTypeList;
import de.ugoe.cs.swe.tTCN3.RecordDef;
import de.ugoe.cs.swe.tTCN3.RecordDefNamed;
import de.ugoe.cs.swe.tTCN3.RecordOfDef;
import de.ugoe.cs.swe.tTCN3.RecordOfDefNamed;
import de.ugoe.cs.swe.tTCN3.ReferencedType;
import de.ugoe.cs.swe.tTCN3.SetDef;
import de.ugoe.cs.swe.tTCN3.SetDefNamed;
import de.ugoe.cs.swe.tTCN3.SetOfDef;
import de.ugoe.cs.swe.tTCN3.SetOfDefNamed;
import de.ugoe.cs.swe.tTCN3.Signature;
import de.ugoe.cs.swe.tTCN3.SignatureDef;
import de.ugoe.cs.swe.tTCN3.StructuredTypeDef;
import de.ugoe.cs.swe.tTCN3.SubTypeDef;
import de.ugoe.cs.swe.tTCN3.SubTypeDefNamed;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import de.ugoe.cs.swe.tTCN3.Type;
import de.ugoe.cs.swe.tTCN3.TypeDef;
import de.ugoe.cs.swe.tTCN3.UnionDef;
import de.ugoe.cs.swe.tTCN3.UnionDefNamed;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class StructureOfDataValidator
extends AbstractDeclarativeValidator {
    private final ConfigTools configTools = ConfigTools.getInstance();
    private QualityCheckProfile activeProfile = (QualityCheckProfile)this.configTools.getSelectedProfile();

    @Check
    public void checkTypeDefOrderInGroup(GroupDef group) {
        StructuredTypeDef struct = null;
        SubTypeDef sub = null;
        String previous = "";
        String current = "";
        if (!this.activeProfile.isCheckTypeDefOrderInGroup() || Objects.equals(group.getList(), null)) {
            return;
        }
        EList<ModuleDefinition> _definitions = group.getList().getDefinitions();
        for (ModuleDefinition d : _definitions) {
            boolean _isNullOrEmpty;
            boolean _not;
            EObject _def = d.getDef();
            if (_def instanceof TypeDef) {
                boolean _notEquals;
                EObject _def_1 = d.getDef();
                struct = ((TypeDef)_def_1).getBody().getStructured();
                EObject _def_2 = d.getDef();
                sub = ((TypeDef)_def_2).getBody().getSub();
                boolean bl = _notEquals = !Objects.equals(struct, null);
                if (_notEquals) {
                    if (!Objects.equals(struct.getRecord(), null) && struct.getRecord() instanceof RecordDefNamed) {
                        RecordDef _record = struct.getRecord();
                        current = ((RecordDefNamed)_record).getName();
                    } else if (!Objects.equals(struct.getUnion(), null) && struct.getUnion() instanceof UnionDefNamed) {
                        UnionDef _union = struct.getUnion();
                        current = ((UnionDefNamed)_union).getName();
                    } else if (!Objects.equals(struct.getSet(), null) && struct.getSet() instanceof SetDefNamed) {
                        SetDef _set = struct.getSet();
                        current = ((SetDefNamed)_set).getName();
                    } else if (!Objects.equals(struct.getRecordOf(), null) && struct.getRecordOf() instanceof RecordOfDefNamed) {
                        RecordOfDef _recordOf = struct.getRecordOf();
                        current = ((RecordOfDefNamed)_recordOf).getName();
                    } else if (!Objects.equals(struct.getSetOf(), null) && struct.getSetOf() instanceof SetOfDefNamed) {
                        SetOfDef _setOf = struct.getSetOf();
                        current = ((SetOfDefNamed)_setOf).getName();
                    } else if (!Objects.equals(struct.getEnumDef(), null) && struct.getEnumDef() instanceof EnumDefNamed) {
                        EnumDef _enumDef = struct.getEnumDef();
                        current = ((EnumDefNamed)_enumDef).getName();
                    } else {
                        boolean _notEquals_1;
                        PortDef _port = struct.getPort();
                        boolean bl2 = _notEquals_1 = !Objects.equals(_port, null);
                        if (_notEquals_1) {
                            PortDef _port_1 = struct.getPort();
                            current = _port_1.getName();
                        } else {
                            boolean _notEquals_2;
                            ComponentDef _component = struct.getComponent();
                            boolean bl3 = _notEquals_2 = !Objects.equals(_component, null);
                            if (_notEquals_2) {
                                ComponentDef _component_1 = struct.getComponent();
                                current = _component_1.getName();
                            }
                        }
                    }
                } else {
                    boolean _notEquals_3;
                    boolean bl4 = _notEquals_3 = !Objects.equals(sub, null);
                    if (_notEquals_3 && sub instanceof SubTypeDefNamed) {
                        current = ((SubTypeDefNamed)sub).getName();
                    }
                }
            }
            boolean bl = _not = !(_isNullOrEmpty = Strings.isNullOrEmpty(current));
            if (!_not) continue;
            this.compareAlphabeticOrder(group, previous, current);
            previous = current;
            current = "";
        }
    }

    private void compareAlphabeticOrder(GroupDef group, String previous, String current) {
        boolean _lessEqualsThan;
        boolean _isNullOrEmpty = Strings.isNullOrEmpty(current);
        if (_isNullOrEmpty) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode(group);
        int _compareToIgnoreCase = current.compareToIgnoreCase(previous);
        boolean bl = _lessEqualsThan = _compareToIgnoreCase <= 0;
        if (_lessEqualsThan) {
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            String _name = group.getName();
            String _plus = "Type definitions <\"" + previous + "\",\"" + current + "\"> within group \"" + _name;
            String message = _plus + "\" are not alphabetically ordered!";
            this.warning(message, (EStructuralFeature)TTCN3Package.eINSTANCE.getTTCN3Reference_Name(), LoggingInterface.MessageClass.STRUCTURE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "4.1, checkTypeDefOrderInGroup");
        }
    }

    @Check
    public void checkPortMessageGrouping(PortDef port) {
        boolean _not;
        boolean _isCheckPortMessageGrouping = this.activeProfile.isCheckPortMessageGrouping();
        boolean bl = _not = !_isCheckPortMessageGrouping;
        if (_not) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode(port);
        GroupDef parentGroup = TTCN3ScopeHelper.findDesiredParent(port, GroupDef.class);
        Object message = "";
        boolean _equals = Objects.equals(parentGroup, null);
        if (_equals) {
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            String _name = port.getName();
            String _plus = "Port type definition for \"" + _name;
            String _plus_1 = _plus + "\" is found outside a group definition! Related messages can therefore never be in the same group as the port definition!";
            message = _plus_1;
            EAttribute _tTCN3Reference_Name = TTCN3Package.eINSTANCE.getTTCN3Reference_Name();
            String _string = LoggingInterface.MessageClass.STRUCTURE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_2 = "4.2, " + _methodName;
            this.warning((String)message, (EStructuralFeature)_tTCN3Reference_Name, _string, _string_1, _string_2, _plus_2);
        } else {
            List<Type> types = EcoreUtil2.getAllContentsOfType(port.getBody().getAttribs(), Type.class);
            List<Signature> signatures = EcoreUtil2.getAllContentsOfType(port.getBody().getAttribs(), Signature.class);
            for (Type t2 : types) {
                boolean _notEquals;
                ReferencedType ref = TTCN3ScopeHelper.getReferencedType(t2.getRef());
                boolean bl2 = _notEquals = !Objects.equals(ref, null);
                if (!_notEquals) continue;
                boolean _matched = false;
                if (ref instanceof SignatureDef) {
                    _matched = true;
                    this.portReferencedTypeCHeck(port, ref, "Message type", t2);
                }
                if (!_matched && ref instanceof RecordDefNamed) {
                    _matched = true;
                    this.portReferencedTypeCHeck(port, ref, "Message type", t2);
                }
                if (!_matched && ref instanceof SetDefNamed) {
                    _matched = true;
                    this.portReferencedTypeCHeck(port, ref, "Message type", t2);
                }
                if (_matched || !(ref instanceof SubTypeDefNamed)) continue;
                _matched = true;
                this.portReferencedTypeCHeck(port, ref, "Message type", t2);
            }
            for (Signature s2 : signatures) {
                this.portReferencedTypeCHeck(port, s2.getRef(), "Signature", s2);
            }
        }
    }

    private void portReferencedTypeCHeck(PortDef port, ReferencedType type, String typeName, EObject reference) {
        boolean _notEquals_1;
        boolean _notEquals;
        ICompositeNode nodePort = NodeModelUtils.getNode(port);
        ICompositeNode nodeType = NodeModelUtils.getNode(type);
        ICompositeNode nodeRef = NodeModelUtils.getNode(reference);
        TTCN3Module parentModulePort = TTCN3ScopeHelper.findDesiredParent(port, TTCN3Module.class);
        TTCN3Module parentModuleType = TTCN3ScopeHelper.findDesiredParent(type, TTCN3Module.class);
        GroupDef parentGroupPort = TTCN3ScopeHelper.findDesiredParent(port, GroupDef.class);
        GroupDef parentGroupType = TTCN3ScopeHelper.findDesiredParent(type, GroupDef.class);
        boolean _equals = Objects.equals(parentGroupType, null);
        if (_equals) {
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            String _name = type.getName();
            String _plus = typeName + " definition for \"" + _name;
            String _plus_1 = _plus + "\" <";
            int _startLine = nodeType.getStartLine();
            String _plus_2 = _plus_1 + String.valueOf((Object)_startLine);
            String _plus_3 = _plus_2 + ",";
            String _name_1 = parentModuleType.getName();
            String _plus_4 = _plus_3 + _name_1;
            String _plus_5 = _plus_4 + ",- ";
            String _plus_6 = _plus_5 + "> ";
            String _plus_7 = _plus_6 + "related to port type definition for \"";
            String _name_2 = port.getName();
            String _plus_8 = _plus_7 + _name_2;
            String _plus_9 = _plus_8 + "\" <";
            int _startLine_1 = nodePort.getStartLine();
            String _plus_10 = _plus_9 + String.valueOf((Object)_startLine_1);
            String _plus_11 = _plus_10 + ",";
            String _name_3 = parentModulePort.getName();
            String _plus_12 = _plus_11 + _name_3;
            String _plus_13 = _plus_12 + ",";
            String _name_4 = parentGroupPort.getName();
            String _plus_14 = _plus_13 + _name_4;
            String _plus_15 = _plus_14 + "> ";
            String message = _plus_15 + "is found outside a group definition! It can therefore never be in the same group as the port type definition!";
            this.warning(message, (EStructuralFeature)TTCN3Package.eINSTANCE.getTTCN3Reference_Name(), LoggingInterface.MessageClass.STRUCTURE.toString(), Integer.valueOf(nodeRef.getStartLine()).toString(), Integer.valueOf(nodeRef.getEndLine()).toString(), "4.2, checkPortMessageGrouping");
            return;
        }
        boolean bl = _notEquals = !Objects.equals(parentModulePort, parentModuleType);
        if (_notEquals) {
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            String _name_5 = type.getName();
            String _plus_16 = typeName + " definition for \"" + _name_5;
            String _plus_17 = _plus_16 + "\" <";
            int _startLine_2 = nodeType.getStartLine();
            String _plus_18 = _plus_17 + String.valueOf((Object)_startLine_2);
            String _plus_19 = _plus_18 + ",";
            String _name_6 = parentModuleType.getName();
            String _plus_20 = _plus_19 + _name_6;
            String _plus_21 = _plus_20 + ",";
            String _name_7 = parentGroupType.getName();
            String _plus_22 = _plus_21 + _name_7;
            String _plus_23 = _plus_22 + "> ";
            String _plus_24 = _plus_23 + "related to port type definition for \"";
            String _name_8 = port.getName();
            String _plus_25 = _plus_24 + _name_8;
            String _plus_26 = _plus_25 + "\" <";
            int _startLine_3 = nodePort.getStartLine();
            String _plus_27 = _plus_26 + String.valueOf((Object)_startLine_3);
            String _plus_28 = _plus_27 + ",";
            String _name_9 = parentModulePort.getName();
            String _plus_29 = _plus_28 + _name_9;
            String _plus_30 = _plus_29 + ",";
            String _name_10 = parentGroupPort.getName();
            String _plus_31 = _plus_30 + _name_10;
            String _plus_32 = _plus_31 + "> ";
            String message_1 = _plus_32 + "is not within the same module as the port type definition! It can therefore never be in the same group as the port definition!";
            this.warning(message_1, (EStructuralFeature)TTCN3Package.eINSTANCE.getTTCN3Reference_Name(), LoggingInterface.MessageClass.STRUCTURE.toString(), Integer.valueOf(nodeRef.getStartLine()).toString(), Integer.valueOf(nodeRef.getEndLine()).toString(), "4.2, checkPortMessageGrouping");
            return;
        }
        boolean bl2 = _notEquals_1 = !Objects.equals(parentGroupPort, parentGroupType);
        if (_notEquals_1) {
            boolean _contains = EcoreUtil2.getAllContentsOfType(parentGroupPort, GroupDef.class).contains(parentGroupType);
            if (_contains) {
                TTCN3StatisticsProvider.getInstance().incrementCountStructure();
                String _name_11 = type.getName();
                String _plus_33 = typeName + " definition for \"" + _name_11;
                String _plus_34 = _plus_33 + "\" <";
                int _startLine_4 = nodeType.getStartLine();
                String _plus_35 = _plus_34 + String.valueOf((Object)_startLine_4);
                String _plus_36 = _plus_35 + ",";
                String _name_12 = parentModuleType.getName();
                String _plus_37 = _plus_36 + _name_12;
                String _plus_38 = _plus_37 + ",";
                String _name_13 = parentGroupType.getName();
                String _plus_39 = _plus_38 + _name_13;
                String _plus_40 = _plus_39 + "> ";
                String _plus_41 = _plus_40 + "related to port type definition for \"";
                String _name_14 = port.getName();
                String _plus_42 = _plus_41 + _name_14;
                String _plus_43 = _plus_42 + "\" <";
                int _startLine_5 = nodePort.getStartLine();
                String _plus_44 = _plus_43 + String.valueOf((Object)_startLine_5);
                String _plus_45 = _plus_44 + ",";
                String _name_15 = parentModulePort.getName();
                String _plus_46 = _plus_45 + _name_15;
                String _plus_47 = _plus_46 + ",";
                String _name_16 = parentGroupPort.getName();
                String _plus_48 = _plus_47 + _name_16;
                String _plus_49 = _plus_48 + "> ";
                String message_2 = _plus_49 + "is within a nested subgroup within the same group as the port type definition!";
                this.info(message_2, (EStructuralFeature)TTCN3Package.eINSTANCE.getTTCN3Reference_Name(), LoggingInterface.MessageClass.STRUCTURE.toString(), Integer.valueOf(nodeRef.getStartLine()).toString(), Integer.valueOf(nodeRef.getEndLine()).toString(), "4.2, checkPortMessageGrouping", LoggingInterface.LogLevel.INFORMATION.toString());
                return;
            }
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            String _name_17 = type.getName();
            String _plus_50 = typeName + " definition for \"" + _name_17;
            String _plus_51 = _plus_50 + "\" <";
            int _startLine_6 = nodeType.getStartLine();
            String _plus_52 = _plus_51 + String.valueOf((Object)_startLine_6);
            String _plus_53 = _plus_52 + ",";
            String _name_18 = parentModuleType.getName();
            String _plus_54 = _plus_53 + _name_18;
            String _plus_55 = _plus_54 + ",";
            String _name_19 = parentGroupType.getName();
            String _plus_56 = _plus_55 + _name_19;
            String _plus_57 = _plus_56 + "> ";
            String _plus_58 = _plus_57 + "related to port type definition for \"";
            String _name_20 = port.getName();
            String _plus_59 = _plus_58 + _name_20;
            String _plus_60 = _plus_59 + "\" <";
            int _startLine_7 = nodePort.getStartLine();
            String _plus_61 = _plus_60 + String.valueOf((Object)_startLine_7);
            String _plus_62 = _plus_61 + ",";
            String _name_21 = parentModulePort.getName();
            String _plus_63 = _plus_62 + _name_21;
            String _plus_64 = _plus_63 + ",";
            String _name_22 = parentGroupPort.getName();
            String _plus_65 = _plus_64 + _name_22;
            String _plus_66 = _plus_65 + "> ";
            String message_3 = _plus_66 + "is not within the same group as the port type definition!";
            this.warning(message_3, (EStructuralFeature)TTCN3Package.eINSTANCE.getTTCN3Reference_Name(), LoggingInterface.MessageClass.STRUCTURE.toString(), Integer.valueOf(nodeRef.getStartLine()).toString(), Integer.valueOf(nodeRef.getEndLine()).toString(), "4.2, checkPortMessageGrouping");
            return;
        }
    }

    @Check
    public void checkNoAllKeywordInPortDefinitions(PortDef port) {
        boolean _not;
        boolean _isCheckNoAllKeywordInPortDefinitions = this.activeProfile.isCheckNoAllKeywordInPortDefinitions();
        boolean bl = _not = !_isCheckNoAllKeywordInPortDefinitions;
        if (_not) {
            return;
        }
        List<ProcOrTypeList> procOrTypeList = EcoreUtil2.getAllContentsOfType(port.getBody().getAttribs(), ProcOrTypeList.class);
        List<AllOrSignatureList> allOrSignatureList = EcoreUtil2.getAllContentsOfType(port.getBody().getAttribs(), AllOrSignatureList.class);
        List<AllOrTypeList> allOrTypeList = EcoreUtil2.getAllContentsOfType(port.getBody().getAttribs(), AllOrTypeList.class);
        for (ProcOrTypeList a : procOrTypeList) {
            boolean _notEquals;
            String _all = a.getAll();
            boolean bl2 = _notEquals = !Objects.equals(_all, null);
            if (!_notEquals) continue;
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            ICompositeNode node = NodeModelUtils.getNode(a);
            String _name = port.getName();
            String _plus = "\"all\" keyword is used in the definition of port \"" + _name;
            String message = _plus + "\"!";
            String _string = LoggingInterface.MessageClass.STRUCTURE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_1 = "4.2.1, " + _methodName;
            this.warning(message, (EObject)a, null, _string, _string_1, _string_2, _plus_1);
        }
        for (AllOrSignatureList a_1 : allOrSignatureList) {
            boolean _notEquals_1;
            String _all_1 = a_1.getAll();
            boolean bl3 = _notEquals_1 = !Objects.equals(_all_1, null);
            if (!_notEquals_1) continue;
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            ICompositeNode node_1 = NodeModelUtils.getNode(a_1);
            String _name_1 = port.getName();
            String _plus_2 = "\"all\" keyword is used in the definition of port \"" + _name_1;
            String message_1 = _plus_2 + "\"!";
            String _string_3 = LoggingInterface.MessageClass.STRUCTURE.toString();
            String _string_4 = Integer.valueOf(node_1.getStartLine()).toString();
            String _string_5 = Integer.valueOf(node_1.getEndLine()).toString();
            String _methodName_1 = MiscTools.getMethodName();
            String _plus_3 = "4.2.1, " + _methodName_1;
            this.warning(message_1, (EObject)a_1, null, _string_3, _string_4, _string_5, _plus_3);
        }
        for (AllOrTypeList a_2 : allOrTypeList) {
            boolean _notEquals_2;
            String _all_2 = a_2.getAll();
            boolean bl4 = _notEquals_2 = !Objects.equals(_all_2, null);
            if (!_notEquals_2) continue;
            TTCN3StatisticsProvider.getInstance().incrementCountStructure();
            ICompositeNode node_2 = NodeModelUtils.getNode(a_2);
            String _name_2 = port.getName();
            String _plus_4 = "\"all\" keyword is used in the definition of port \"" + _name_2;
            String message_2 = _plus_4 + "\"!";
            String _string_6 = LoggingInterface.MessageClass.STRUCTURE.toString();
            String _string_7 = Integer.valueOf(node_2.getStartLine()).toString();
            String _string_8 = Integer.valueOf(node_2.getEndLine()).toString();
            String _methodName_2 = MiscTools.getMethodName();
            String _plus_5 = "4.2.1, " + _methodName_2;
            this.warning(message_2, (EObject)a_2, null, _string_6, _string_7, _string_8, _plus_5);
        }
    }

    @Override
    public void register(EValidatorRegistrar registrar) {
    }
}

