/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.common;

import de.ugoe.cs.swe.common.exceptions.TerminationException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiscTools {
    public static String readFile(String filename) {
        FileInputStream fis = null;
        String content = "";
        try {
            try {
                fis = new FileInputStream(filename);
                int x = fis.available();
                byte[] b = new byte[x];
                fis.read(b);
                content = new String(b);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String message = "IO ERROR: Filename " + filename + " cannot be found for reading!";
                try {
                    throw new TerminationException(message);
                }
                catch (TerminationException terminationException) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    public static String getShortFilename(String filename) {
        String shortfilename = new File(filename).getName();
        return shortfilename;
    }

    public static String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    public static void writeFile(String filename, String content) {
        File targetDir = new File(filename).getAbsoluteFile().getParentFile();
        try {
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                System.out.println("IO ERROR: Creating the directory structure for \"" + filename + "\" failed!");
            }
            try {
                FileOutputStream fos = new FileOutputStream(filename);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fos));
                w.write(content);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SecurityException securityException) {
            System.out.println("IO ERROR: Could not create ouput files and / or directories!Caused by: \"" + filename + "\"");
        }
    }

    public static void streamCopyFile(String sourceFilename, String targetFilename) {
        try {
            File targetFile = new File(targetFilename);
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                System.out.println("IO ERROR: Creating the directory structure for \"" + targetFilename + "\" failed!");
            }
            FileOutputStream outStream = new FileOutputStream(targetFile);
            FileInputStream inStream = new FileInputStream(sourceFilename);
            try {
                int c;
                while ((c = inStream.read()) != -1) {
                    outStream.write(c);
                }
            }
            catch (IOException iOException) {
                System.out.println("IO ERROR: Caused while copying: \"" + sourceFilename + "\" to \"" + targetFilename + "\"");
            }
        }
        catch (FileNotFoundException e1) {
            System.out.println("IO ERROR: File not found: \"" + sourceFilename + " / " + targetFilename + "\"");
            e1.printStackTrace();
        }
    }

    public static int getLOC(String filename) {
        String code = MiscTools.readFile(filename);
        int LOC = code.split("\n").length;
        return LOC;
    }

    public static String doubleToString(double d) {
        DecimalFormat fmt = new DecimalFormat("0.00");
        String string = fmt.format(d);
        return string;
    }

    public static String msToString(long millis) {
        String res = String.format("%d:%02d", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        return res;
    }

    public static String secondsToString(long seconds) {
        int minutes = (int)seconds / 60;
        int remainder = (int)seconds % 60;
        DecimalFormat fmt = new DecimalFormat("00");
        String string = minutes + ":" + fmt.format(remainder);
        return string;
    }

    public static String getSubPath(String inputPath) {
        String subPath = "";
        File input = new File(MiscTools.getProperInputPath(inputPath));
        subPath = input.isFile() ? input.getName().substring(0, input.getName().lastIndexOf(".")) : input.getName();
        return subPath;
    }

    public static String getProperOutputPath(String outputDirectory) {
        String properOutputPath = "";
        try {
            properOutputPath = new File(outputDirectory).getCanonicalPath();
        }
        catch (IOException e) {
            System.out.println("IO ERROR: ");
            e.printStackTrace();
        }
        return properOutputPath;
    }

    public static String getProperInputPath(String inputPath) {
        String properInputPath = new File(inputPath).getPath();
        if (properInputPath.equals(".")) {
            try {
                properInputPath = new File(properInputPath).getCanonicalFile().getName();
            }
            catch (IOException e) {
                System.out.println("IO ERROR: ");
                e.printStackTrace();
            }
        }
        return properInputPath;
    }

    public static boolean regExpMatch(String regExp, String subject) {
        Pattern pattern;
        Matcher matcher;
        boolean matches = false;
        if (regExp != null && (matcher = (pattern = Pattern.compile(regExp)).matcher(subject)).matches()) {
            matches = true;
        }
        return matches;
    }
}

